package gov.va.genisis2.bs.data.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * Label - Stores data associated with a label
 * @author Michael Edoror
 */
@Entity
@Table(name = "labels")
public class Label implements Serializable {

	private static final long serialVersionUID = 1L;

	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private int labelId;
	
	@Column(name = "bookmark_id", insertable = false, updatable = false)
	private int bookmarkId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "bookmark_id" )
	private Bookmark bookmark;
	
	@Column(name = "name")
	private String name;
	
	@Column(name = "created_by")
	private String username;

	/**
	 * @return the labelId
	 */
	public int getLabelId() {
		return labelId;
	}

	/**
	 * @param labelId the labelId to set
	 */
	public void setLabelId(int labelId) {
		this.labelId = labelId;
	}

	/**
	 * @return the bookmarkId
	 */
	public int getBookmarkId() {
		return bookmarkId;
	}

	/**
	 * @param bookmarkId the bookmarkId to set
	 */
	public void setBookmarkId(int bookmarkId) {
		this.bookmarkId = bookmarkId;
	}

	/**
	 * @return the bookmark
	 */
	public Bookmark getBookmark() {
		return bookmark;
	}

	/**
	 * @param bookmark the bookmark to set
	 */
	public void setBookmark(Bookmark bookmark) {
		this.bookmark = bookmark;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @param username the username to set
	 */
	public void setUsername(String username) {
		this.username = username;
	}
}
